<?php
/**
 * تأیید کد بازیابی رمز
 * POST: phoneNumber, code (۴ رقم)
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true) ?? [];
$phoneNumber = trim((string) ($input['phoneNumber'] ?? ''));
$code = trim((string) ($input['code'] ?? ''));

if (!preg_match('/^09\d{9}$/', $phoneNumber) || !preg_match('/^\d{4}$/', $code)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'شماره یا کد معتبر نیست.']);
    exit;
}

$pdo = getDb();
$stmt = $pdo->prepare('SELECT id FROM password_reset_codes WHERE phone = ? AND code = ? AND expires_at > NOW() AND used_at IS NULL ORDER BY created_at DESC LIMIT 1');
$stmt->execute([$phoneNumber, $code]);
if (!$stmt->fetch()) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'کد اشتباه یا منقضی شده است.']);
    exit;
}

echo json_encode(['ok' => true]);