<?php
/**
 * به‌روزرسانی پروفایل کاربر
 * POST: user_id, و فیلدهای اختیاری fullName, email, age, height, weight, bio, profileImage, theme
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true) ?? [];
$userId = isset($input['user_id']) ? (int) $input['user_id'] : 0;
if ($userId <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'user_id required']);
    exit;
}

$pdo = getDb();
$stmt = $pdo->prepare('SELECT id FROM users WHERE id = ?');
$stmt->execute([$userId]);
if (!$stmt->fetch()) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'User not found']);
    exit;
}

$updates = [];
$params = [];
if (array_key_exists('fullName', $input)) {
    $v = trim((string) $input['fullName']);
    if ($v !== '') {
        $updates[] = 'full_name = ?';
        $params[] = $v;
    }
}
if (array_key_exists('email', $input)) {
    $updates[] = 'email = ?';
    $params[] = trim((string) $input['email']) ?: null;
}
if (array_key_exists('age', $input)) {
    $v = $input['age'];
    $updates[] = 'age = ?';
    $params[] = ($v === '' || $v === null) ? null : (int) $v;
}
if (array_key_exists('height', $input)) {
    $v = $input['height'];
    $updates[] = 'height_cm = ?';
    $params[] = ($v === '' || $v === null) ? null : (int) $v;
}
if (array_key_exists('weight', $input)) {
    $v = $input['weight'];
    $updates[] = 'weight_kg = ?';
    $params[] = ($v === '' || $v === null) ? null : (float) $v;
}
if (array_key_exists('bio', $input)) {
    $updates[] = 'bio = ?';
    $params[] = trim((string) $input['bio']) ?: null;
}
if (array_key_exists('profileImage', $input)) {
    $v = trim((string) $input['profileImage']);
    if ($v === '') {
        $updates[] = 'profile_image_url = ?';
        $params[] = null;
    } else {
        // داده base64 (data URL) یا URL؛ حداکثر ۲ مگابایت برای جلوگیری از سوءاستفاده
        $maxLen = 2 * 1024 * 1024;
        if (strlen($v) > $maxLen) {
            $v = substr($v, 0, $maxLen);
        }
        $updates[] = 'profile_image_url = ?';
        $params[] = $v;
    }
}
if (array_key_exists('theme', $input)) {
    $updates[] = 'theme = ?';
    $params[] = trim((string) $input['theme']) ?: 'normal';
}

if (empty($updates)) {
    echo json_encode(['ok' => true]);
    exit;
}

$params[] = $userId;
$sql = 'UPDATE users SET ' . implode(', ', $updates) . ' WHERE id = ?';
$stmt = $pdo->prepare($sql);
$stmt->execute($params);

echo json_encode(['ok' => true]);