<?php
/**
 * درخواست کد بازیابی رمز (فراموشی رمز)
 * POST: phoneNumber
 * اگر SMS_FROM و SMS_PASSWORD در config باشند از Send.asmx استفاده می‌شود (کد ۴ رقمی خودمان + متن پیامک).
 * وگرنه از کنسول OTP (SMS_OTP_API_URL) و در صورت برگرداندن code در پاسخ، ذخیره می‌شود.
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/sms.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true) ?? [];
$phoneNumber = trim((string) ($input['phoneNumber'] ?? ''));

if (!preg_match('/^09\d{9}$/', $phoneNumber)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'شماره تماس معتبر نیست.']);
    exit;
}

$pdo = getDb();
$stmt = $pdo->prepare('SELECT id FROM users WHERE phone = ?');
$stmt->execute([$phoneNumber]);
if (!$stmt->fetch()) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'این شماره در سامانه ثبت نشده است.']);
    exit;
}

$useSimpleSend = defined('SMS_FROM') && SMS_FROM !== '' && defined('SMS_PASSWORD') && SMS_PASSWORD !== '';

if ($useSimpleSend) {
    // روش وب‌سرویس Send.asmx: کد ۴ رقمی خودمان را می‌سازیم، ذخیره می‌کنیم، پیامک می‌فرستیم
    $code = (string) random_int(1000, 9999);
    $expiresAt = date('Y-m-d H:i:s', time() + 15 * 60);
    $stmt = $pdo->prepare('INSERT INTO password_reset_codes (phone, code, expires_at) VALUES (?, ?, ?)');
    $stmt->execute([$phoneNumber, $code, $expiresAt]);

    $text = "نوآتن: کد بازیابی رمز شما: {$code}";
    $smsResult = send_simple_sms($phoneNumber, $text);

    if (!$smsResult['success']) {
        http_response_code(500);
        echo json_encode(['ok' => false, 'error' => $smsResult['message'] ?? 'ارسال پیامک انجام نشد.']);
        exit;
    }
    echo json_encode(['ok' => true]);
    exit;
}

// روش کنسول OTP
$smsResult = send_otp($phoneNumber);
if (!$smsResult['success']) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => $smsResult['message'] ?? 'ارسال پیامک انجام نشد.']);
    exit;
}
if (!empty($smsResult['code'])) {
    $code = preg_replace('/\D/', '', (string) $smsResult['code']);
    $code = strlen($code) >= 4 ? substr($code, -4) : $code;
    if ($code !== '') {
        $expiresAt = date('Y-m-d H:i:s', time() + 15 * 60);
        $stmt = $pdo->prepare('INSERT INTO password_reset_codes (phone, code, expires_at) VALUES (?, ?, ?)');
        $stmt->execute([$phoneNumber, $code, $expiresAt]);
    }
}
echo json_encode(['ok' => true]);
