<?php
/**
 * ثبت‌نام کاربر جدید
 * POST: fullName, phoneNumber, password
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true) ?? [];
$fullName   = trim((string) ($input['fullName'] ?? ''));
$phoneNumber = trim((string) ($input['phoneNumber'] ?? ''));
$password   = (string) ($input['password'] ?? '');
$isCoach    = !empty($input['isCoach']);
$coachBio   = $isCoach ? trim((string) ($input['coachBio'] ?? '')) : '';
$coachSpecialty = $isCoach ? trim((string) ($input['coachSpecialty'] ?? '')) : '';
$coachExperience = $isCoach ? trim((string) ($input['coachExperience'] ?? '')) : '';

// اعتبارسنجی
$errors = [];
if (strlen($fullName) < 3) {
    $errors['fullName'] = 'نام باید حداقل ۳ کاراکتر باشد.';
}
if (!preg_match('/^09\d{9}$/', $phoneNumber)) {
    $errors['phoneNumber'] = 'شماره تماس معتبر نیست (09xxxxxxxxx).';
}
if (strlen($password) < 6) {
    $errors['password'] = 'رمز عبور باید حداقل ۶ کاراکتر باشد.';
}
if ($isCoach && strlen($coachBio) < 10) {
    $errors['coachBio'] = 'خلاصه/بیو برای مربی حداقل ۱۰ کاراکتر باشد.';
}

if (!empty($errors)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'errors' => $errors]);
    exit;
}

$pdo = getDb();

// بررسی تکراری نبودن شماره
$stmt = $pdo->prepare('SELECT id FROM users WHERE phone = ?');
$stmt->execute([$phoneNumber]);
if ($stmt->fetch()) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'این شماره قبلاً ثبت شده است.', 'errors' => ['phoneNumber' => 'این شماره قبلاً ثبت شده است.']]);
    exit;
}

// ذخیره کاربر با رمز هش‌شده
$passwordHash = password_hash($password, PASSWORD_DEFAULT);

$hasRole = false;
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'role'");
    $hasRole = $stmt->fetch() !== false;
} catch (Throwable $e) {
}

if ($hasRole && $isCoach) {
    $stmt = $pdo->prepare('INSERT INTO users (full_name, phone, password_hash, role, bio) VALUES (?, ?, ?, ?, ?)');
    $bioText = $coachBio;
    if ($coachSpecialty !== '') $bioText .= "\n\nتخصص: " . $coachSpecialty;
    if ($coachExperience !== '') $bioText .= "\nتجربه: " . $coachExperience;
    $stmt->execute([$fullName, $phoneNumber, $passwordHash, 'coach', $bioText]);
} elseif ($hasRole) {
    $stmt = $pdo->prepare('INSERT INTO users (full_name, phone, password_hash, role) VALUES (?, ?, ?, ?)');
    $stmt->execute([$fullName, $phoneNumber, $passwordHash, 'user']);
} else {
    $stmt = $pdo->prepare('INSERT INTO users (full_name, phone, password_hash) VALUES (?, ?, ?)');
    $stmt->execute([$fullName, $phoneNumber, $passwordHash]);
}
$userId = (int) $pdo->lastInsertId();

// ردیف اولیه در user_stats در صورت وجود جدول
try {
    $stmtStats = $pdo->prepare('INSERT INTO user_stats (user_id, streak, points, level) VALUES (?, 0, 0, 1)');
    $stmtStats->execute([$userId]);
} catch (Throwable $e) {
    // نادیده؛ کاربر ثبت شده است
}

echo json_encode([
    'ok'   => true,
    'user' => [
        'id'        => $userId,
        'fullName'  => $fullName,
        'phone'     => $phoneNumber,
    ],
]);
