<?php
/**
 * ورود کاربر
 * POST: phoneNumber, password
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true) ?? [];
$phoneNumber = trim((string) ($input['phoneNumber'] ?? ''));
$password    = (string) ($input['password'] ?? '');

if (!preg_match('/^09\d{9}$/', $phoneNumber) || strlen($password) < 6) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'شماره تماس یا رمز عبور معتبر نیست.']);
    exit;
}

$pdo = getDb();
$stmt = $pdo->prepare('SELECT id, full_name, phone, password_hash FROM users WHERE phone = ?');
$stmt->execute([$phoneNumber]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || !password_verify($password, $user['password_hash'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'شماره تماس یا رمز عبور اشتباه است.']);
    exit;
}

// به‌روزرسانی زمان آخرین ورود
$stmtUpdate = $pdo->prepare('UPDATE users SET last_login_at = NOW() WHERE id = ?');
$stmtUpdate->execute([(int) $user['id']]);

echo json_encode([
    'ok'   => true,
    'user' => [
        'id'       => (int) $user['id'],
        'fullName' => $user['full_name'],
        'phone'    => $user['phone'],
    ],
]);
