<?php
/**
 * دریافت پروفایل کاربر
 * GET: user_id (یا query: user_id=123)
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'GET' && $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$userId = isset($_GET['user_id']) ? (int) $_GET['user_id'] : null;
if ($userId === null && $_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true) ?? [];
    $userId = isset($input['user_id']) ? (int) $input['user_id'] : null;
}
if ($userId <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'user_id required']);
    exit;
}

$pdo = getDb();
$stmt = $pdo->prepare('SELECT id, full_name, phone, email, age, height_cm, weight_kg, bio, profile_image_url, theme FROM users WHERE id = ?');
$stmt->execute([$userId]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$row) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'User not found']);
    exit;
}

$profile = [
    'id'        => (int) $row['id'],
    'fullName' => $row['full_name'],
    'phone'    => $row['phone'],
    'email'    => $row['email'] ?? '',
    'age'      => $row['age'] !== null ? (int) $row['age'] : null,
    'height'   => $row['height_cm'] !== null ? (int) $row['height_cm'] : null,
    'weight'   => $row['weight_kg'] !== null ? (float) $row['weight_kg'] : null,
    'bio'      => $row['bio'] ?? '',
    'profileImage' => $row['profile_image_url'] ?? '',
    'theme'    => $row['theme'] ?? 'normal',
];
echo json_encode(['ok' => true, 'profile' => $profile]);
