<?php
/**
 * لیست مربیان
 * GET: بدون پارامتر یا با page, limit
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$pdo = getDb();

// اگر ستون role وجود نداشت، فقط full_name و id برگردان (سازگاری با دیتابیس قدیمی)
$hasRole = false;
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'role'");
    $hasRole = $stmt->fetch() !== false;
} catch (Throwable $e) {
}

if (!$hasRole) {
    echo json_encode(['ok' => true, 'coaches' => []]);
    exit;
}

$stmt = $pdo->query("
  SELECT id, full_name, profile_image_url, bio, phone, email
  FROM users
  WHERE role = 'coach'
  ORDER BY full_name
");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

$coaches = [];
foreach ($rows as $row) {
    $coaches[] = [
        'id'        => (int) $row['id'],
        'fullName'  => $row['full_name'],
        'profileImage' => $row['profile_image_url'] ?? '',
        'bio'       => $row['bio'] ?? '',
        'phone'     => $row['phone'],
        'email'     => $row['email'] ?? '',
    ];
}

echo json_encode(['ok' => true, 'coaches' => $coaches]);
