<?php
/**
 * جزئیات یک مربی
 * GET: coach_id=123
 */
define('NOVATAN_API', true);
require_once __DIR__ . '/cors.php';
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    http_response_code(405);
    echo json_encode(['ok' => false, 'error' => 'Method not allowed']);
    exit;
}

$coachId = isset($_GET['coach_id']) ? (int) $_GET['coach_id'] : 0;
if ($coachId <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'coach_id required']);
    exit;
}

$pdo = getDb();

$hasRole = false;
try {
    $stmt = $pdo->query("SHOW COLUMNS FROM users LIKE 'role'");
    $hasRole = $stmt->fetch() !== false;
} catch (Throwable $e) {
}

$sql = "SELECT id, full_name, profile_image_url, bio, phone, email FROM users WHERE id = ?";
$params = [$coachId];
if ($hasRole) {
    $sql = "SELECT id, full_name, profile_image_url, bio, phone, email FROM users WHERE id = ? AND role = 'coach'";
}
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$row) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Coach not found']);
    exit;
}

$coach = [
    'id'           => (int) $row['id'],
    'fullName'     => $row['full_name'],
    'profileImage' => $row['profile_image_url'] ?? '',
    'bio'          => $row['bio'] ?? '',
    'phone'        => $row['phone'],
    'email'        => $row['email'] ?? '',
];

echo json_encode(['ok' => true, 'coach' => $coach]);
