<?php
/**
 * اتصال به دیتابیس با PDO
 */
if (!defined('NOVATAN_API')) {
    die('Direct access not allowed');
}

require_once __DIR__ . '/config.php';

$db = null;

function getDb(): PDO {
    global $db;
    if ($db !== null) {
        return $db;
    }
    try {
        $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
        $db = new PDO($dsn, DB_USER, DB_PASS, [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        return $db;
    } catch (PDOException $e) {
        header('Content-Type: application/json; charset=utf-8');
        http_response_code(500);
        echo json_encode([
            'ok'    => false,
            'error' => 'Database connection failed',
        ]);
        exit;
    }
}
